/*
 *  kexbases\kernel32\_kernel32_apilist.h
 *
 *  Copyright (C) 2008, Xeno86
 *  Copyright (C) 2019, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _KERNEL32_APILIST_H
#define _KERNEL32_APILIST_H

#include "kexcoresdk.h"
#include <tlhelp32.h>
#include "SList.h"

BOOL init_kernel32();
extern const apilib_api_table apitable_kernel32;


/*** AUTOGENERATED APILIST DECLARATIONS BEGIN ***/

// kernel32\CompletionPorts.c
HANDLE WINAPI CreateIoCompletionPort_new(HANDLE FileHandle, HANDLE ExistingCompletionPort, ULONG_PTR CompletionKey, DWORD NumberOfConcurrentThreads);
BOOL WINAPI GetQueuedCompletionStatus_new(HANDLE CompletionPort, LPDWORD lpNumberOfBytes, PULONG_PTR lpCompletionKey, LPOVERLAPPED *lpOverlapped, DWORD dwMilliseconds);
BOOL WINAPI PostQueuedCompletionStatus_new(HANDLE CompletionPort, DWORD dwNumberOfBytesTransferred, ULONG_PTR dwCompletionKey, LPOVERLAPPED lpOverlapped);

// kernel32\CopyFileEx.c
BOOL WINAPI CopyFileExA_new(LPCSTR lpExistingFileNameA, LPCSTR lpNewFileNameA, LPPROGRESS_ROUTINE lpProgressRoutine, LPVOID lpData, LPBOOL pbCancel, DWORD dwCopyFlags);

// kernel32\CriticalSection_fix.c
DWORD WINAPI SetCriticalSectionSpinCount_new(LPCRITICAL_SECTION lpCriticalSection, DWORD dwSpinCount);
void WINAPI EnterCriticalSection_fix(LPCRITICAL_SECTION lpCriticalSection);
void WINAPI LeaveCriticalSection_fix(LPCRITICAL_SECTION lpCriticalSection);
void WINAPI DeleteCriticalSection_fix(LPCRITICAL_SECTION lpCriticalSection);

// kernel32\Debug.c
void WINAPI OutputDebugStringAW_stub (LPSTR str);
void WINAPI OutputDebugStringA_new (LPSTR str);
void WINAPI OutputDebugStringW_new (LPCWSTR strW);
void DebugBreak_stub (void);
void DebugBreak_new (void);
BOOL IsDebuggerPresent_no (void);
BOOL IsDebuggerPresent_yes (void);

// kernel32\DllDirectory.c
BOOL WINAPI SetEnvironmentVariableW_new(LPCWSTR lpNameW, LPCWSTR lpValueW);
DWORD WINAPI GetDllDirectoryA_new(DWORD nSize, LPSTR lpPathA);
DWORD WINAPI GetDllDirectoryW_new(DWORD nSize, LPWSTR lpPathW);
BOOL WINAPI SetDllDirectoryA_new(LPCSTR lpPathA);
BOOL WINAPI SetDllDirectoryW_new(LPCWSTR lpPathW);

// kernel32\FileApis_fix.c
HANDLE WINAPI CreateFileA_fix(LPCSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes, DWORD dwCreationDistribution, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile);
BOOL WINAPI ReadFile_fix(HANDLE hFile, LPVOID lpBuffer, DWORD nNumberOfBytesToRead, LPDWORD lpNumberOfBytesRead, LPOVERLAPPED lpOverlapped);
BOOL WINAPI WriteFile_fix(HANDLE hFile, LPCVOID lpBuffer, DWORD nNumberOfBytesToWrite, LPDWORD lpNumberOfBytesWritten, LPOVERLAPPED lpOverlapped);
UINT WINAPI GetTempFileNameA_fix(LPCSTR lpPathName, LPCSTR lpPrefixString, UINT uUnique, LPTSTR lpTempFileName);
BOOL WINAPI GetDiskFreeSpaceA_fix(LPCSTR lpRootPathName, LPDWORD lpSectorsPerCluster, LPDWORD lpBytesPerSector, LPDWORD lpNumberOfFreeClusters, LPDWORD lpTotalNumberOfClusters);
BOOL WINAPI GetDiskFreeSpaceExA_fix(LPCSTR lpDirectoryName, PULARGE_INTEGER lpFreeBytesAvailable, PULARGE_INTEGER lpTotalNumberOfBytes, PULARGE_INTEGER lpTotalNumberOfFreeBytes);

// kernel32\FindFirstFileEx.c
HANDLE WINAPI FindFirstFileExA_new(LPCSTR lpFileNameA, FINDEX_INFO_LEVELS fInfoLevelId, LPWIN32_FIND_DATAA lpFindFileDataA, FINDEX_SEARCH_OPS fSearchOp, LPVOID lpSearchFilter, DWORD dwAdditionalFlags);
HANDLE WINAPI FindFirstFileExW_new(LPWSTR lpFileNameW, FINDEX_INFO_LEVELS fInfoLevelId, LPWIN32_FIND_DATAW lpFindFileDataW, FINDEX_SEARCH_OPS fSearchOp, LPVOID lpSearchFilter, DWORD dwAdditionalFlags);

// kernel32\GetConsoleWindow.c
HWND WINAPI GetConsoleWindow_new();

// kernel32\GetFileSizeEx.c
BOOL WINAPI GetFileSizeEx_new(HANDLE hFile, PLARGE_INTEGER lpFileSize);

// kernel32\GetModuleHandleEx.c
BOOL WINAPI GetModuleHandleExA_new(DWORD dwFlags, LPCSTR pModuleName, HMODULE* phModule);
BOOL WINAPI GetModuleHandleExW_new(DWORD dwFlags, LPCWSTR lpModuleNameW, HMODULE* phModule);

// kernel32\GetTickCount64.c
UINT64 WINAPI GetTickCount64_new (void);

// kernel32\GlobalMemoryStatusEx.c
BOOL WINAPI GlobalMemoryStatusEx_new(LPMEMORYSTATUSEX lpmemex);
BOOL WINAPI GlobalMemoryStatusEx_new_1(LPMEMORYSTATUSEX lpmemex);

// kernel32\HeapLocks.c
BOOL WINAPI HeapLock_new(HANDLE hHeap);
BOOL WINAPI HeapUnlock_new(HANDLE hHeap);
LPVOID WINAPI GlobalLock_fix(HGLOBAL hMem);
BOOL WINAPI GlobalUnlock_fix(HGLOBAL hMem);

// kernel32\InitializeCriticalSectionAndSpinCount.c
BOOL WINAPI InitializeCriticalSectionAndSpinCount_new (LPCRITICAL_SECTION lpCriticalSection, DWORD dwSpinCount);
BOOL WINAPI InitializeCriticalSectionEx_new (LPCRITICAL_SECTION lpCriticalSection, DWORD dwSpinCount, DWORD flags);

// kernel32\IsProcessorFeaturePresent.c
BOOL WINAPI IsProcessorFeaturePresent_new(DWORD feature);

// kernel32\Jobs.c
HANDLE WINAPI CreateJobObjectA_new(LPSECURITY_ATTRIBUTES sa, LPCSTR name);
HANDLE WINAPI CreateJobObjectW_new(LPSECURITY_ATTRIBUTES sa, LPCWSTR name);
BOOL WINAPI TerminateJobObject_new(HANDLE job, UINT exit_code);
HANDLE WINAPI OpenJobObjectA_new(DWORD access, BOOL inherit, LPCSTR name);
HANDLE WINAPI OpenJobObjectW_new(DWORD access, BOOL inherit, LPCWSTR name);
BOOL WINAPI QueryInformationJobObject_new(HANDLE job, PVOID classs, LPVOID info, DWORD len, DWORD *ret_len);
BOOL WINAPI SetInformationJobObject_new(HANDLE job, PVOID classs, LPVOID info, DWORD len);
BOOL WINAPI AssignProcessToJobObject_new(HANDLE job, HANDLE process);
BOOL WINAPI IsProcessInJob_new(HANDLE process, HANDLE job, PBOOL result);

// kernel32\KEXVersion.c
void WINAPI KEXVersion(char* out);

// kernel32\LoadLibrary.c
HINSTANCE WINAPI LoadLibraryExA_fix(LPCSTR pLibFileNameA, HANDLE hFile, DWORD dwFlags);
HINSTANCE WINAPI LoadLibraryA_fix(LPCSTR pLibFileNameA);
HINSTANCE WINAPI LoadLibraryExW_new(LPCWSTR pLibFileNameW, HANDLE hFile, DWORD dwFlags);
HINSTANCE WINAPI LoadLibraryW_new(LPCWSTR pLibFileNameW);

// kernel32\LockFileEx.c
LockFileEx_need();
BOOL WINAPI UnlockFileEx_new(HANDLE hFile, DWORD dwReserved, DWORD nNumberOfBytesToUnlockLow, DWORD nNumberOfBytesToUnlockHigh, LPOVERLAPPED lpOverlapped);

// kernel32\MapViewOfFile.c
LPVOID WINAPI MapViewOfFileEx_new(HANDLE hFileMappingObject, DWORD dwDesiredAccess, DWORD dwFileOffsetHigh, DWORD dwFileOffsetLow, SIZE_T dwNumberOfBytesToMap, LPVOID lpBaseAddress);
LPVOID WINAPI MapViewOfFile_new(HANDLE hFileMappingObject, DWORD dwDesiredAccess, DWORD dwFileOffsetHigh, DWORD dwFileOffsetLow, SIZE_T dwNumberOfBytesToMap);

// kernel32\MoveFileExA.c
BOOL WINAPI MoveFileExA_new(LPCSTR lpExistingFileNameA, LPCSTR lpNewFileNameA, DWORD dwFlags);

// kernel32\MoveFileWithProgressA.c
BOOL WINAPI MoveFileWithProgressA_new(LPCSTR lpExistingFileName, LPCSTR lpNewFileName, LPPROGRESS_ROUTINE lpProgressRoutine, LPVOID lpData, DWORD dwFlags);

// kernel32\PowerRequest.c

// kernel32\PowerRequestSleek.c

// kernel32\RtlCaptureContext.c
void WINAPI RtlCaptureContext_new(void* cr);

// kernel32\SList.c
void WINAPI InitializeSListHead_new (PHEAD pHead);
PITEM WINAPI InterlockedFlushSList_new (PHEAD pHead);
PITEM WINAPI InterlockedPopEntrySList_new (PHEAD pHead);
PITEM WINAPI InterlockedPushEntrySList_new (PHEAD pHead, PITEM pItem);
PITEM __fastcall InterlockedPushListSList_new (PHEAD pHead, PITEM pList, PITEM pListEnd, ULONG Count);
PITEM WINAPI InterlockedPushListSListEx_new (PHEAD pHead, PITEM pList, PITEM pEnd, ULONG Count);
DWORD WINAPI QueryDepthSList_new (PHEAD pHead);

// kernel32\SRW.c
BOOL WINAPI TryAcquireSRWLockExclusive (int *pLock);
BOOL WINAPI TryAcquireSRWLockShared (int *pLock);
void WINAPI AcquireSRWLockExclusive (int *pLock);
void WINAPI AcquireSRWLockShared (int *pLock);
void WINAPI InitializeSRWLock (int *pLock);
void WINAPI ReleaseSRWLockExclusive (int *pLock);
void WINAPI ReleaseSRWLockShared (int *pLock);

// kernel32\SetFilePointerEx.c
BOOL WINAPI SetFilePointerEx_new(HANDLE hFile, LARGE_INTEGER liMove, PLARGE_INTEGER lpNewFilePointer, DWORD dwMoveMethod);
DWORD WINAPI SetFilePointer_fix (HANDLE hFile, LONG Low, PLONG pHigh, DWORD dwMoveMethod);
LONG WINAPI _llseek_fix (HFILE hFile, LONG Low, int iOrigin);

// kernel32\SignalObjectAndWait.c
DWORD SignalObjectAndWait_nt (HANDLE hObjectToSignal, HANDLE hObjectToWaitOn, DWORD dwMilliseconds, BOOL bAlertable);

// kernel32\TryEnterCriticalSection.c
BOOL WINAPI TryEnterCriticalSection_new(CRITICAL_SECTION* cs);

// kernel32\VirtualAllocEx.c
LPVOID WINAPI VirtualAllocEx_new(HANDLE hProcess, LPVOID lpAddress, DWORD dwSize, DWORD flAllocationType, DWORD flProtect);
BOOL WINAPI VirtualFreeEx_new(HANDLE hProcess, LPVOID lpAddress, DWORD dwSize, DWORD dwFreeType);

// kernel32\VirtualProtect.c
BOOL WINAPI VirtualProtect_fix(LPVOID lpRegion, DWORD dwSize, DWORD flNewProtect, PDWORD lpflOldProtect);

// kernel32\Vista.c
HANDLE CreateEventExA_vista (LPSECURITY_ATTRIBUTES lpEventAttributes, LPCSTR lpName, DWORD dwFlags, DWORD dwDesiredAccess);

// kernel32\_kernel32_apilist.c

// kernel32\_kernel32_stubs.c
STUB CreateHardLinkA_stub;
STUB CreateHardLinkW_stub;
STUB IsValidLanguageGroup_stub;
STUB ReplaceFileA_stub;
STUB ReplaceFileW_stub;
STUB HeapSetInformation_stub;
STUB GetProcessIoCounters_stub;
STUB RtlCaptureStackBackTrace_stub;
STUB GetComputerNameExA_stub;
STUB GetComputerNameExW_stub;
STUB GetLogicalProcessorInformation_stub;
STUB GetNumaHighestNodeNumber_stub;
STUB HeapQueryInformation_stub;
STUB WTSGetActiveConsoleSessionId_stub;
STUB GetSystemWow64DirectoryA_stub;
STUB GetSystemWow64DirectoryW_stub;
STUB GetVolumeNameForVolumeMountPointA_stub;
STUB GetVolumeNameForVolumeMountPointW_stub;
STUB GetVolumePathNamesForVolumeNameA_stub;
STUB GetVolumePathNamesForVolumeNameW_stub;
STUB ActivateActCtx_stub;
STUB AddRefActCtx_stub;
STUB CreateActCtxA_stub;
STUB CreateActCtxW_stub;
STUB DeactivateActCtx_stub;
STUB FindActCtxSectionGuid_stub;
STUB FindActCtxSectionStringA_stub;
STUB FindActCtxSectionStringW_stub;
STUB GetCurrentActCtx_stub;
STUB IsolationAwareCleanup_stub;
STUB QueryActCtxSettingsW_stub;
STUB QueryActCtxW_stub;
STUB ReleaseActCtx_stub;
STUB ZombifyActCtx_stub;
STUB AddVectoredExceptionHandler_stub;
STUB AttachConsole_stub;
STUB CheckNameLegalDOS8Dot3_stub;
STUB CheckRemoteDebuggerPresent_stub;
STUB CreateMemoryResourceNotification_stub;
STUB DebugActiveProcessStop_stub;
STUB DebugSetProcessKillOnExit_stub;
STUB DnsHostnameToComputerNameW_stub;
STUB FindFirstVolumeA_stub;
STUB FindFirstVolumeW_stub;
STUB FindNextVolumeA_stub;
STUB FindNextVolumeW_stub;
STUB FindVolumeClose_stub;
STUB FlsAlloc_stub;
STUB FlsFree_stub;
STUB FlsGetValue_stub;
STUB FlsSetValue_stub;
STUB GetConsoleDisplayMode_stub;
STUB GetGeoInfoA_stub;
STUB GetGeoInfoW_stub;
STUB GetProcessHandleCount_stub;
STUB GetSystemRegistryQuota_stub;
STUB GetSystemTimes_stub;
STUB GetThreadId_stub;
STUB GetUserGeoID_stub;
STUB QueryMemoryResourceNotification_stub;
STUB RemoveVectoredExceptionHandler_stub;
STUB SetConsoleDisplayMode_stub;
STUB SetFileValidData_stub;
STUB WerRegisterMemoryBlock_stub;
STUB Wow64DisableWow64FsRedirection_stub;
STUB Wow64EnableWow64FsRedirection_stub;
STUB Wow64RevertWow64FsRedirection_stub;
STUB SetProcessDEPPolicy_stub;
STUB PowerCreateRequest_stub;
STUB PowerSetRequest_stub;
STUB PowerClearRequest_stub;
STUB PrivCopyFileExW_stub;
STUB ResolveLocaleName_stub;
STUB QueryFullProcessImageNameA_stub;
STUB QueryFullProcessImageNameW_stub;
STUB ConvertFiberToThread_stub;
STUB QueryThreadCycleTime_stub;
STUB DebugBreakProcess_stub;
STUB ReOpenFile_stub;
STUB SetFileCompletionNotificationModes_stub;
STUB FindFirstVolumeMountPointA_stub;
STUB FindFirstVolumeMountPointW_stub;
STUB FindNextVolumeMountPointA_stub;
STUB FindNextVolumeMountPointW_stub;
STUB FindVolumeMountPointClose_stub;

// kernel32\locale.c
INT WINAPI CompareStringW_new(LCID lcid, DWORD style, LPCWSTR str1, INT len1, LPCWSTR str2, INT len2);
BOOL WINAPI GetStringTypeW_new(DWORD type, LPCWSTR src, INT count, LPWORD chartype);
BOOL WINAPI GetStringTypeExW_new(LCID locale, DWORD type, LPCWSTR src, INT count, LPWORD chartype);
INT WINAPI LCMapStringW_new(LCID lcid, DWORD flags, LPCWSTR src, INT srclen, LPWSTR dst, INT dstlen);
INT WINAPI FoldStringW_new(DWORD dwFlags, LPCWSTR src, INT srclen, LPWSTR dst, INT dstlen);
INT WINAPI FoldStringA_new(DWORD dwFlags, LPCSTR src, INT srclen, LPSTR dst, INT dstlen);
int WINAPI lstrcmpW_new(LPCWSTR str1, LPCWSTR str2);
int WINAPI lstrcmpiW_new(LPCWSTR str1, LPCWSTR str2);

// kernel32\locale_casemap.c

// kernel32\locale_collation.c

// kernel32\locale_fold.c

// kernel32\locale_sortkey.c

// kernel32\locale_wctype.c

// kernel32\pointer.c
PVOID WINAPI XorPointer(PVOID ptr);

// kernel32\process.c
BOOL WINAPI CreateProcessA_fix(LPCSTR lpApplicationName, LPSTR lpCommandLine, LPSECURITY_ATTRIBUTES lpProcessAttributes, LPSECURITY_ATTRIBUTES lpThreadAttributes, BOOL bInheritHandles, DWORD dwCreationFlags, LPVOID lpEnvironment, LPCSTR lpCurrentDirectory, LPSTARTUPINFOA lpStartupInfo, LPPROCESS_INFORMATION lpProcessInformation);
BOOL WINAPI CreateProcessAsUserA_new(HANDLE hToken, LPCSTR lpApplicationName, LPSTR lpCommandLine, LPSECURITY_ATTRIBUTES lpProcessAttributes, LPSECURITY_ATTRIBUTES lpThreadAttributes, BOOL bInheritHandles, DWORD dwCreationFlags, LPVOID lpEnvironment, LPCSTR lpCurrentDirectory, LPSTARTUPINFOA lpStartupInfo, LPPROCESS_INFORMATION lpProcessInformation);
VOID WINAPI ExitProcess_fix(UINT uExitCode);
DWORD WINAPI GetProcessId_new(HANDLE hProcess);
BOOL WINAPI IsWow64Process_new(HANDLE hProcess, PBOOL Wow64Process);
BOOL WINAPI ProcessIdToSessionId_new(DWORD dwProcessId, DWORD *pSessionId);

// kernel32\thread.c
LPVOID WINAPI CreateFiberEx_new(SIZE_T dwStackCommitSize, SIZE_T dwStackReserveSize, DWORD dwFlags, LPFIBER_START_ROUTINE lpStartAddress, LPVOID lpParameter);
HANDLE WINAPI CreateRemoteThread_new(HANDLE hProcess, LPSECURITY_ATTRIBUTES lpThreadAttributes, SIZE_T dwStackSize, LPTHREAD_START_ROUTINE lpStartAddress, LPVOID lpParameter, DWORD dwCreationFlags, LPDWORD lpThreadId);
HANDLE WINAPI CreateThread_fix(LPSECURITY_ATTRIBUTES lpThreadAttributes, SIZE_T dwStackSize, LPTHREAD_START_ROUTINE lpStartAddress, LPVOID lpParameter, DWORD dwCreationFlags, LPDWORD lpThreadId);
HANDLE WINAPI OpenThread_new(DWORD dwDesiredAccess, BOOL bInheritHandle, DWORD dwThreadId);

// kernel32\time.c
BOOL WINAPI SystemTimeToTzSpecificLocalTime_new(const TIME_ZONE_INFORMATION *lpTimeZoneInformation, const SYSTEMTIME *lpUniversalTime, LPSYSTEMTIME lpLocalTime);
BOOL WINAPI TzSpecificLocalTimeToSystemTime_new(const TIME_ZONE_INFORMATION *lpTimeZoneInformation, const SYSTEMTIME *lpLocalTime, LPSYSTEMTIME lpUniversalTime);

// kernel32\uilang.c
LANGID WINAPI GetDefaultUILanguage_new(void);
BOOL WINAPI EnumUILanguagesA_new(UILANGUAGE_ENUMPROCA pUILangEnumProc, DWORD dwFlags, LONG_PTR lParam);
BOOL WINAPI EnumUILanguagesW_new(UILANGUAGE_ENUMPROCW pUILangEnumProc, DWORD dwFlags, LONG_PTR lParam);
LANGID WINAPI SetThreadUILanguage_new(LANGID LangId);

// kernel32\unikernel32.c
ATOM WINAPI AddAtomW_new(LPCWSTR strW);
BOOL WINAPI CopyFileExW_new(LPCWSTR lpExistingFileNameW, LPCWSTR lpNewFileNameW, LPPROGRESS_ROUTINE lpProgressRoutine, LPVOID lpData, LPBOOL pbCancel, DWORD dwCopyFlags);
BOOL WINAPI CopyFileW_new(LPCWSTR lpExistingFileNameW, LPCWSTR lpNewFileNameW, BOOL bFailIfExists);
BOOL WINAPI CreateDirectoryExW_new(LPCWSTR templatedirW, LPCWSTR newdirW, LPSECURITY_ATTRIBUTES secattr);
BOOL WINAPI CreateDirectoryW_new(LPCWSTR PathW, LPSECURITY_ATTRIBUTES SecAttr);
HANDLE WINAPI CreateFileW_new(LPCWSTR strW, DWORD access, DWORD sharemode, LPSECURITY_ATTRIBUTES secattr, DWORD creatdistr, DWORD flags, HANDLE temp);
BOOL WINAPI CreateProcessW_new (LPCWSTR lpApplicationNameW, LPWSTR lpCommandLineW, LPSECURITY_ATTRIBUTES lpProcessAttributes, LPSECURITY_ATTRIBUTES lpThreadAttributes, BOOL bInheritHandles, DWORD dwCreationFlags, LPVOID lpEnvironment, LPCWSTR lpCurrentDirectoryW, LPSTARTUPINFOW lpStartupInfo, LPPROCESS_INFORMATION lpProcessInformation);
BOOL WINAPI DefineDosDeviceW_new(DWORD dwFlags, LPCWSTR lpDeviceNameW, LPCWSTR lpTargetPathW);
BOOL WINAPI DeleteFileW_new(LPCWSTR lpFileNameW);
ATOM WINAPI FindAtomW_new(LPCWSTR strW);
HANDLE WINAPI FindFirstChangeNotificationW_new(LPCWSTR pathW, BOOL watchsubtree, DWORD filter);
HANDLE WINAPI FindFirstFileW_new(LPCWSTR strW, LPWIN32_FIND_DATAW dataW);
BOOL WINAPI FindNextFileW_new(HANDLE handle, LPWIN32_FIND_DATAW dataW);
HRSRC WINAPI FindResourceExW_new(HMODULE hModule, LPCWSTR typeW, LPCWSTR nameW, WORD lang);
HRSRC WINAPI FindResourceW_new(HINSTANCE hModule, LPCWSTR name, LPCWSTR type);
BOOL WINAPI FreeEnvironmentStringsW_new(void* env);
UINT WINAPI GetAtomNameW_new(ATOM atom, LPWSTR bufferW, int size);
DWORD WINAPI GetCurrentDirectoryW_new(DWORD nBufferLength, LPWSTR lpBufferW);
BOOL WINAPI GetDefaultCommConfigW_new(LPCWSTR lpszNameW, LPCOMMCONFIG lpCC, LPDWORD lpdwSize);
BOOL WINAPI GetDiskFreeSpaceExW_new(LPCWSTR lpDirectoryNameW, PULARGE_INTEGER lpFreeBytesAvailableToCaller, PULARGE_INTEGER lpTotalNumberOfBytes, PULARGE_INTEGER lpTotalNumberOfFreeBytes);
BOOL WINAPI GetDiskFreeSpaceW_new(LPCWSTR lpRootPathNameW, LPDWORD lpSectorsPerCluster, LPDWORD lpBytesPerSector, LPDWORD lpNumberOfFreeClusters, LPDWORD lpTotalNumberOfClusters);
void* WINAPI GetEnvironmentStringsW_new(void);
BOOL WINAPI GetFileAttributesExW_new(LPCWSTR lpFileNameW, GET_FILEEX_INFO_LEVELS fInfoLevelId, LPVOID lpFileInformation);
DWORD WINAPI GetFileAttributesW_new(LPCWSTR lpFileNameW);
DWORD WINAPI GetFullPathNameW_new(LPCWSTR lpFileNameW, DWORD nBufferLength, LPWSTR lpBufferW, LPWSTR *lpFilePartW);
int WINAPI GetLocaleInfoW_new(LCID Locale, LCTYPE LCType, LPWSTR lpLCData, int cchData);
DWORD WINAPI GetLongPathNameW_new(LPCWSTR lpszShortPathW, LPWSTR lpszLongPathW, DWORD cchBuffer);
DWORD WINAPI GetModuleFileNameW_new(HMODULE hModule, LPWSTR lpFilenameW, DWORD nSize);
HMODULE WINAPI GetModuleHandleW_new(LPCWSTR lpModuleNameW);
DWORD WINAPI GetShortPathNameW_new(LPCWSTR lpszLongPathW, LPWSTR lpszShortPathW, DWORD cchBuffer);
VOID WINAPI GetStartupInfoW_new(LPSTARTUPINFOW lpStartupInfo);
UINT WINAPI GetSystemDirectoryW_new(LPWSTR lpBufferW, UINT uSize);
UINT WINAPI GetTempFileNameW_new(LPCWSTR lpPathNameW, LPCWSTR lpPrefixStringW, UINT uUnique, LPWSTR lpTempFileNameW);
DWORD WINAPI GetTempPathW_new(DWORD nBufferLength, LPWSTR lpBufferW);
UINT WINAPI GetWindowsDirectoryW_new(LPWSTR lpBufferW, UINT uSize);
ATOM WINAPI GlobalAddAtomW_new(LPCWSTR strW);
ATOM WINAPI GlobalFindAtomW_new(LPCWSTR strW);
UINT WINAPI GlobalGetAtomNameW_new(ATOM atom, LPWSTR bufferW, int size);
BOOL WINAPI Module32FirstW_new(HANDLE hSnapshot, LPMODULEENTRY32W lpmeW);
BOOL WINAPI Module32NextW_new(HANDLE hSnapshot, LPMODULEENTRY32W lpmeW);
BOOL WINAPI MoveFileExW_new(LPCWSTR existingfileW, LPCWSTR newfileW, DWORD flags);
BOOL WINAPI MoveFileW_new(LPCWSTR existingfileW, LPCWSTR newfileW);
BOOL WINAPI MoveFileWithProgressW_new(LPCWSTR existingfileW, LPCWSTR newfileW, LPPROGRESS_ROUTINE lpProgressRoutine, LPVOID lpData, DWORD dwFlags);
BOOL WINAPI Process32FirstW_new(HANDLE hSnapshot, LPPROCESSENTRY32W lppeW);
BOOL WINAPI Process32NextW_new(HANDLE hSnapshot, LPPROCESSENTRY32W lppeW);
BOOL WINAPI RemoveDirectoryW_new(LPCWSTR lpPathNameW);
DWORD WINAPI SearchPathW_new(LPCWSTR lpPathW, LPCWSTR lpFileNameW, LPCWSTR lpExtensionW, DWORD nBufferLength, LPWSTR lpBufferW, LPWSTR *lpFilePartW);
BOOL WINAPI SetConsoleTitleW_new(LPCWSTR strW);
BOOL WINAPI SetCurrentDirectoryW_new(LPCWSTR lpPathNameW);
BOOL WINAPI SetFileAttributesW_new(LPCWSTR lpFileNameW, DWORD dwFileAttributes);
DWORD WINAPI VerLanguageNameW_new(DWORD wLang, LPWSTR szLangW, DWORD nSize);
LPWSTR WINAPI lstrcpynW_new(LPWSTR dst, LPCWSTR src, INT n);
BOOL WINAPI ReadConsoleInputW_new(HANDLE hConsoleInput, PINPUT_RECORD lpBuffer, DWORD nLength, LPDWORD lpNumberOfEventsRead);

// kernel32\version.c
ULONGLONG WINAPI VerSetConditionMask_new(ULONGLONG dwlConditionMask, DWORD dwTypeBitMask, BYTE dwConditionMask);
DWORD WINAPI GetVersion_WIN95(void);
DWORD WINAPI GetVersion_WIN98x(void);
DWORD WINAPI GetVersion_WINME(void);
DWORD WINAPI GetVersion_NT40G(void);
DWORD WINAPI GetVersion_WIN2000D(void);
DWORD WINAPI GetVersion_WINXPx(void);
DWORD WINAPI GetVersion_WIN2003A(void);
DWORD WINAPI GetVersion_VISTA(void);
DWORD WINAPI GetVersion_WIN2008A(void);
BOOL WINAPI GetVersionExA_ORIG(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_ORIG(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI GetVersionExA_WIN95(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_WIN95(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI GetVersionExA_WIN98SE(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_WIN98SE(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI GetVersionExA_WINME(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_WINME(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI GetVersionExA_NT40G(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_NT40G(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI GetVersionExA_WIN2000D(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_WIN2000D(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI GetVersionExA_WINXP2(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_WINXP2(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI GetVersionExA_WIN2003A(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_WIN2003A(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI GetVersionExA_VISTA(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_VISTA(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI GetVersionExA_WIN2008A(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_WIN2008A(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI VerifyVersionInfoA_WIN2000D(LPOSVERSIONINFOEXA lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI VerifyVersionInfoW_WIN2000D(LPOSVERSIONINFOEXW lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI VerifyVersionInfoA_WINXP2(LPOSVERSIONINFOEXA lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI VerifyVersionInfoW_WINXP2(LPOSVERSIONINFOEXW lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI VerifyVersionInfoA_WIN2003A(LPOSVERSIONINFOEXA lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI VerifyVersionInfoW_WIN2003A(LPOSVERSIONINFOEXW lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI VerifyVersionInfoA_VISTA(LPOSVERSIONINFOEXA lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI VerifyVersionInfoW_VISTA(LPOSVERSIONINFOEXW lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI VerifyVersionInfoA_WIN2008A(LPOSVERSIONINFOEXA lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI VerifyVersionInfoW_WIN2008A(LPOSVERSIONINFOEXW lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
DWORD WINAPI GetVersion_VISTA2(void);
BOOL WINAPI GetVersionExA_VISTA2(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_VISTA2(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI VerifyVersionInfoA_VISTA2(LPOSVERSIONINFOEXA lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI VerifyVersionInfoW_VISTA2(LPOSVERSIONINFOEXW lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
DWORD WINAPI GetVersion_WIN7A(void);
BOOL WINAPI GetVersionExA_WIN7A(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_WIN7A(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI VerifyVersionInfoA_WIN7A(LPOSVERSIONINFOEXA lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI VerifyVersionInfoW_WIN7A(LPOSVERSIONINFOEXW lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
DWORD WINAPI GetVersion_WIN8(void);
BOOL WINAPI GetVersionExA_WIN8(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_WIN8(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI VerifyVersionInfoA_WIN8(LPOSVERSIONINFOEXA lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI VerifyVersionInfoW_WIN8(LPOSVERSIONINFOEXW lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
DWORD WINAPI GetVersion_WIN81(void);
BOOL WINAPI GetVersionExA_WIN81(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_WIN81(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI VerifyVersionInfoA_WIN81(LPOSVERSIONINFOEXA lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI VerifyVersionInfoW_WIN81(LPOSVERSIONINFOEXW lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
DWORD WINAPI GetVersion_WIN10(void);
BOOL WINAPI GetVersionExA_WIN10(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_WIN10(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI VerifyVersionInfoA_WIN10(LPOSVERSIONINFOEXA lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI VerifyVersionInfoW_WIN10(LPOSVERSIONINFOEXW lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
DWORD WINAPI GetVersion_WIN10A(void);
BOOL WINAPI GetVersionExA_WIN10A(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_WIN10A(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI VerifyVersionInfoA_WIN10A(LPOSVERSIONINFOEXA lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI VerifyVersionInfoW_WIN10A(LPOSVERSIONINFOEXW lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI GetVersionExA_WIN98(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_WIN98(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI GetVersionExA_WINXP(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_WINXP(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI VerifyVersionInfoA_WINXP(LPOSVERSIONINFOEXA lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI VerifyVersionInfoW_WINXP(LPOSVERSIONINFOEXW lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI GetVersionExA_WINXP3(LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW_WINXP3(LPOSVERSIONINFOW lpVersionInfo);
BOOL WINAPI VerifyVersionInfoA_WINXP3(LPOSVERSIONINFOEXA lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);
BOOL WINAPI VerifyVersionInfoW_WINXP3(LPOSVERSIONINFOEXW lpVersionInfo, DWORD dwTypeMask, DWORDLONG dwlConditionMask);

// kernel32\volume.c
BOOL WINAPI GetVolumePathNameA_new(LPCSTR filename, LPSTR volumepathname, DWORD buflen);
BOOL WINAPI GetVolumePathNameW_new(LPCWSTR filenameW, LPWSTR volumepathnameW, DWORD buflen);

// kernel32\widecharconv.c
int WINAPI WideCharToMultiByte_fix(UINT CodePage, DWORD dwFlags, LPCWSTR lpWideCharStr, int cchWideChar, LPSTR lpMultiByteStr, int cchMultiByte, LPCSTR lpDefaultChar, LPBOOL lpUsedDefaultChar);
int WINAPI MultiByteToWideChar_fix(UINT CodePage, DWORD dwFlags, LPCSTR lpMultiByteStr, int cchMultiByte, LPWSTR lpWideCharStr, int cchWideChar);
/*** AUTOGENERATED APILIST DECLARATIONS END ***/

#endif
